import 'package:flutter/material.dart';
import 'package:front_end_russia/global/services/theme_service.dart';

class AppColor {
  AppColor._privateConstructor();

  static final AppColor colors = AppColor._privateConstructor();
  // var mainColor = const Color(0xFFFE5368);
  var mainColor = const Color(0xFF6849DD);
  var mainBgColor = const Color(0xFF7159FF);
  var themeColor = const Color(0xFFFE5368);

  var pink = const Color(0xFFFCB4DF);
  var pink2 = const Color(0xFFF8D3EE);
  var purple = const Color(0xFF6849DD);
  var purple1 = const Color(0xff4b48f3);
  var purple2 = const Color(0xff1B104A);
  var grey11 = const Color(0x0FF7F7F7);
  var grey1 = const Color(0xFFF7F7F7);
  var grey2 = const Color(0xFFEEEDFB);
  var grey3 = const Color(0xFFF3F4F9);
  var grey33 = const Color(0xFFECEDFA);
  var grey4 = const Color(0xFFDBDCDD);
  var grey5 = const Color(0xFFCCCCDA);
  var grey6 = const Color(0xFF4C4C48);
  var grey7 = const Color(0xFFF5F5F5);
  var black1 = const Color(0x90000000);
  var black2 = const Color(0xff363636);
  var black3 = const Color(0xff1C212D);

  var blue1 = const Color(0xff3262C7);
  var blue2 = const Color(0xff3980B6);

  var red1 = const Color(0xFFEF2F5A);
  var yellow1 = const Color(0xFFF4EA2C);
  var yellow2 = const Color(0xFFE79641);
  var green1 = const Color(0xFF9be34f);

  var white1 = const Color(0xFfffffff);
  var white2d = const Color(0x2DFFFFFF);
  var white2 = const Color(0xFfFFF9FF);

  var diamondBgColor = const Color(0xFFFF7AB1);

  /// 获取主题相关的颜色
  static Color getThemeColor() {
    return ThemeService.to.isDarkMode ? Colors.white : ThemeService.to.primaryColor;
  }

  /// 获取主题相关的背景色
  static Color getThemeBackgroundColor() {
    return ThemeService.to.isDarkMode ? const Color(0xFF2A2A3E) : Colors.white;
  }

  /// 获取主题相关的文本颜色
  static Color getThemeTextColor() {
    return ThemeService.to.isDarkMode ? Colors.white : const Color(0xFF2D3436);
  }

  /// 获取主题相关的次要文本颜色
  static Color getThemeSecondaryTextColor() {
    return ThemeService.to.isDarkMode
        ? Colors.white.withValues(alpha: 0.7)
        : Colors.grey[600]!;
  }

  /// 获取主题相关的边框颜色
  static Color getThemeBorderColor() {
    return ThemeService.to.isDarkMode
        ? Colors.white.withValues(alpha: 0.2)
        : Colors.grey[300]!;
  }

  /// 获取主题相关的卡片背景色
  static Color getThemeCardColor() {
    return ThemeService.to.isDarkMode ? const Color(0xFF3A3A4E) : Colors.white;
  }
}
